<?php
/* --------------------------------------------------------------
   TrackingCodes.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Model;

use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeId;
use Gambio\Admin\TrackingCode\Interfaces\TrackingCodeIds as TrackingCodeIdsInterface;
use Traversable;
use Webmozart\Assert\Assert;

/**
 * Class TrackingCodeIds
 *
 * @package Gambio\Admin\TrackingCode\Model
 */
class TrackingCodeIds implements TrackingCodeIdsInterface
{
    /**
     * @var TrackingCodeId[]
     */
    private $ids;
    
    
    /**
     * TrackingCodeIds constructor.
     *
     * @param array $ids
     */
    private function __construct(array $ids)
    {
        $this->ids = $ids;
    }
    
    
    /**
     * @param TrackingCodeId ...$ids
     *
     * @return TrackingCodeIds
     */
    public static function create(TrackingCodeId ...$ids): TrackingCodeIds
    {
        return new self($ids);
    }
    
    
    /**
     * @param TrackingCodeId[] $ids
     *
     * @return TrackingCodeIds
     */
    public static function createWithReferences($ids): TrackingCodeIds
    {
        Assert::allIsInstanceOf($ids,
                                TrackingCodeId::class,
                                'All IDs need to implement the "' . TrackingCodeId::class . '" interface.');
        
        return new self($ids);
    }
    
    
    /**
     * @inheritDoc
     */
    public function getIterator(): Traversable
    {
        return new \ArrayIterator($this->ids);
    }
    
    
    /**
     * @inheritDoc
     */
    public function items(): array
    {
        return $this->ids;
    }
    
    
    /**
     * @inheritDoc
     */
    public function jsonSerialize(): array
    {
        return $this->items();
    }
}